<x-platform-layout>
    <div class="md:pt-12 border-t">
        <section class="max-w-screen md:mb-10">
            <div class="relative bg-white overflow-hidden shadow-lg">
                <div class="max-w-7xl mx-auto">
                    <div class="relative z-10 pb-8 bg-white sm:pb-16 md:pb-20 lg:max-w-2xl lg:w-full lg:pb-28 xl:pb-32">
                        <svg class="hidden lg:block absolute right-0 inset-y-0 h-full w-48 text-white transform translate-x-1/2"
                            fill="currentColor" viewBox="0 0 100 100" preserveAspectRatio="none" aria-hidden="true">
                            <polygon points="50,0 100,0 50,100 0,100" />
                        </svg>

                        <div class="relative pt-6 px-4 sm:px-6 lg:px-8">

                        </div>

                        <main class="mt-10 mx-auto max-w-7xl px-4 sm:mt-12 sm:px-6 md:mt-16 lg:mt-20 lg:px-8 xl:mt-28">
                            <div class="sm:text-center lg:text-left">
                                <h1
                                    class="text-4xl tracking-tight font-extrabold text-gray-900 sm:text-5xl md:text-6xl">
                                    <span class="block xl:inline">Seja um Paciente na BioReligare</span>
                                   
                                </h1>
                                <p
                                    class="mt-3 text-base text-gray-500 sm:mt-5 sm:text-lg sm:max-w-xl sm:mx-auto md:mt-5 md:text-xl lg:mx-0">
                                    Realize consultas online de forma fácil, rápida e sem sair de casa
                                </p>
                                <div class="mt-5 sm:mt-8 sm:flex sm:justify-center lg:justify-start">
                                    <div class="rounded-md shadow">
                                        <a href="#"
                                            class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-primary-600 hover:bg-primary-700 md:py-4 md:text-lg md:px-10">
                                            Quero fazer meu cadastro
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </main>
                    </div>
                </div>
                <div class="lg:absolute lg:inset-y-0 lg:right-0 lg:w-1/2">
                    <img class="h-56 w-full object-cover sm:h-72 md:h-96 lg:w-full lg:h-full"
                        src="https://st2.depositphotos.com/3662505/7656/i/600/depositphotos_76566549-stock-photo-psychotherapy.jpg"
                        alt="">
                </div>
            </div>
        </section>
        <section class="bg-white overflow-hidden border-t ">
            <div class="relative max-w-screen sm:items-center sm:justify-center">
                <div class="mt-8 mx-auto text-base max-w-prose lg:max-w-none">
                        <div class="bg-gradient-to-br to-secondary-900 from-primary-800">
                            <div class="max-w-4xl mx-auto px-4 py-16 sm:px-6 sm:pt-20 sm:pb-24 lg:max-w-7xl lg:pt-24 lg:px-8">
                                
                                <h2 class="text-xl text-white tracking-tight">
                                    Para o paciente, o médico. Para o médico, o paciente.
                                </h2>
                                <h2 class="text-3xl font-extrabold text-white tracking-tight">
                                    Benefícios da Clínica virtual
                                </h2>
                                <div class="mt-12 grid grid-cols-3 gap-x-6 gap-y-12 sm:grid-cols-3 lg:mt-16 lg:grid-cols-3 lg:gap-x-8 lg:gap-y-16">
                                    <div>
                                        <div>
                                        <span class="flex items-center justify-center h-12 w-12 rounded-md bg-white bg-opacity-10">
                                            <!-- Heroicon name: outline/inbox -->
                                            <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                                            </svg>
                                        </span>
                                        </div>
                                        <div class="mt-6">
                                            <h3 class="text-lg font-medium text-white">Uma central única para atender todas as necessidades</h3>

                                        </div>
                                    </div>

                                    <div>
                                        <div>
                                        <span class="flex items-center justify-center h-12 w-12 rounded-md bg-white bg-opacity-10">
                                            <!-- Heroicon name: outline/users -->
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </span>
                                        </div>
                                        <div class="mt-6">
                                        <h3 class="text-lg font-medium text-white">Amplo horario de atendimento</h3>
                                        </div>
                                    </div>

                                    <div>
                                        <div>
                                            <span class="flex items-center justify-center h-12 w-12 rounded-md bg-white bg-opacity-10">
                                                <!-- Heroicon name: outline/trash -->
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                                </svg>
                                            </span>
                                        </div>
                                        <div class="mt-6">
                                            <h3 class="text-lg font-medium text-white">Sempre que ligar, será atendido</h3>
                                        </div>
                                    </div>
                                </div>
                                <a href="{{ route('platform.register') }}"
                                class="mt-8 bg-white border border-transparent rounded-md shadow px-6 py-3 inline-flex items-center text-base font-medium text-secondary-1100 hover:bg-gray-200">
                                {{ __('Entre em contato') }}</a>
                            </div>

                        </div>
            </div>
        </section>

        <section>

        <div class="py-16 bg-gray-50 overflow-hidden lg:py-24">
            <div class="relative max-w-xl mx-auto px-4 sm:px-6 lg:px-8 lg:max-w-7xl">
                <svg class="hidden lg:block absolute left-full transform -translate-x-1/2 -translate-y-1/4" width="404" height="784" fill="none" viewBox="0 0 404 784" aria-hidden="true">
                <defs>
                    <pattern id="b1e6e422-73f8-40a6-b5d9-c8586e37e0e7" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                    <rect x="0" y="0" width="4" height="4" class="text-gray-200" fill="currentColor" />
                    </pattern>
                </defs>
                <rect width="404" height="784" fill="url(#b1e6e422-73f8-40a6-b5d9-c8586e37e0e7)" />
                </svg>

                <div class="relative">
                    <h2 class="text-center text-3xl leading-8 font-extrabold tracking-tight text-gray-900 sm:text-4xl">
                        Como funciona a terapia online
                    </h2>
                </div>

                <div class="relative mt-12 lg:mt-24 lg:grid lg:grid-cols-2 lg:gap-8 lg:items-center">
                    <div class="relative">

                        <p class="mt-3 text-lg text-gray-500">
                        Na BioReligare você encontra um ambiente 100% seguro, exclusivo para o seu atendimento. Somente você e seu Profissional da Saúde tem acesso à sessão e aos dados e informações trocados nela. Nenhuma sessão é gravada, respeitando o princípio da confidencialidade entre Profissional e cliente.
                        </p>
                  
                    </div>

                    <div class="mt-10 -mx-4 relative lg:mt-0" aria-hidden="true">
                        <svg class="absolute left-1/2 transform -translate-x-1/2 translate-y-16 lg:hidden" width="784" height="404" fill="none" viewBox="0 0 784 404">
                        <defs>
                            <pattern id="ca9667ae-9f92-4be7-abcb-9e3d727f2941" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                            <rect x="0" y="0" width="4" height="4" class="text-gray-200" fill="currentColor" />
                            </pattern>
                        </defs>
                        <rect width="784" height="404" fill="url(#ca9667ae-9f92-4be7-abcb-9e3d727f2941)" />
                        </svg>
                        <img class="relative mx-auto" width="490" src="https://upload.wikimedia.org/wikipedia/commons/thumb/0/02/Circle-icons-computer.svg/1200px-Circle-icons-computer.svg.png" alt="">
                    </div>

   
                </div>

                <a href="{{ route('platform.register') }}"
                                class="text-white mt-8 bg-primary-600 hover:bg-primary-700 border border-transparent rounded-md shadow px-6 py-3 inline-flex items-center text-base font-medium  hover:bg-gray-200">
                                {{ __('Comece agora') }}</a>
        </section>


        <section>

        <div class="relative bg-white py-16 sm:py-24 lg:py-32">
            <div class="mx-auto max-w-md px-4 text-center sm:max-w-3xl sm:px-6 lg:px-8 lg:max-w-7xl">
                <p class="mt-2 text-3xl font-extrabold text-gray-900 tracking-tight sm:text-4xl">
                Como começar a minha terapia online?
                </p>
                <div class="mt-12">
                <div class="grid grid-cols-1 gap-8 sm:grid-cols-2 lg:grid-cols-3">
                    <div class="pt-6">
                    <div class="flow-root bg-gray-50 rounded-lg px-6 pb-8">
                        <div class="-mt-6">
                        <div>
                            <span class="inline-flex items-center justify-center p-3 bg-gradient-to-br to-secondary-900 from-primary-800 rounded-md shadow-lg">
                            <!-- Heroicon name: outline/cloud-upload -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                            </span>
                        </div>
                        <h3 class="mt-8 text-lg font-medium text-gray-900 tracking-tight">Encontre o seu Profissional da Saúde</h3>
                        </div>
                    </div>
                    </div>

                    <div class="pt-6">
                    <div class="flow-root bg-gray-50 rounded-lg px-6 pb-8">
                        <div class="-mt-6">
                        <div>
                            <span class="inline-flex items-center justify-center p-3 bg-gradient-to-br to-secondary-900 from-primary-800 rounded-md shadow-lg">
                            <!-- Heroicon name: outline/lock-closed -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                            </span>
                        </div>
                        <h3 class="mt-8 text-lg font-medium text-gray-900 tracking-tight">Escolha a data e horario de sua preferência</h3>
                        </div>
                    </div>
                    </div>

                    <div class="pt-6">
                    <div class="flow-root bg-gray-50 rounded-lg px-6 pb-8">
                        <div class="-mt-6">
                        <div>
                            <span class="inline-flex items-center justify-center p-3 bg-gradient-to-br to-secondary-900 from-primary-800 rounded-md shadow-lg">
                            <!-- Heroicon name: outline/refresh -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            </span>
                        </div>
                        <h3 class="mt-8 text-lg font-medium text-gray-900 tracking-tight">Defina o método de pagamento que se encaixe melhor a você</h3>
                        </div>
                    </div>
                    </div>    
                </div>
                </div>
            </div>
            </div>
        </section>
        <section class="bg-white overflow-hidden border-t ">
            <div class="relative max-w-screen">
                <div class="mt-8 mx-auto text-base max-w-prose lg:max-w-none">
                        <div class="bg-gradient-to-br to-secondary-900 from-primary-800">
                            <div class="max-w-4xl mx-auto px-4 py-16 sm:px-6 sm:pt-20 sm:pb-24 lg:max-w-7xl lg:pt-24 lg:px-8">
                                
                                
                                <h2 class="text-3xl font-extrabold text-white tracking-tight">
                                    Quem nunca teve dificuldade em agendar uma consulta?
                                </h2>
                                <h2 class="text-3xl font-extrabold text-white tracking-tight">
                                    Quem nunca ficou esperando na linha até ser atendido e a chamada caiu?
                                </h2>
                                <h2 class="mt-4 text-xl text-white tracking-tight">
                                    Aqui na BioReligare nosso atendimento é rapido e objetivo
                                </h2>
                                <h2 class="text-xl text-white tracking-tight">
                                    Através de um número único, você vai ligar, ser prontamente atendido e em poucos minutos encontraremos o profissional de saúde que você busca. No horário que você quer, no dia que você quer e próximo de onde você estiver.
                                </h2>
                                <h2 class="mt-4 text-2xl text-white tracking-tight">
                                    Chega de esperar, agora você liga, nós atendemos e agendamos!
                                </h2>
                               
                            </div>

                        </div>
            </div>
        </section>
    </div>
</x-platform-layout>
